function cryocare_fields = tm_get_cryocare_fields(task)
%% tm_get_cryocare_fields
% Return parameter fields for a given tomoman_cryoCARE task. 
%
% WW 06-2023

%% Get fields

switch task
    case 'cryocare_oe_recons'
        cryocare_fields = {'n_cores','num';...
                           'gpu_id','num';...
                           'ali_dim','num';...
                           'erase_radius','num';...
                           'taper_pixels','num';...
                           'ali_stack_bin','num';...
                           'process_stack','str';...
                           'radial','num';...
                           'tomo_bin','num';...
                           'output_dir_prefix','str';...
                           'recons_list','str';...
                           'force_oe_recons','boo';...
                           'f3d_memlimit','num';...
                           };
        
    case 'cryocare_train'
        cryocare_fields = {'cryocare_dir','str';...
                           'gpu_id','num';...
                           'tomo_dir', 'str';...
                           'subset_list', 'str';...
                           'patch_shape','num';...
                           'num_slices','num';...
                           'n_normalization_samples','';...
                           'model_name','str';...
                           'epochs','num';...
                           'steps_per_epoch','num';...
                           'batch_size','num';...
                           'unet_kern_size','num';...
                           'unet_n_depth','num';...
                           'unet_n_first','num';...
                           'learning_rate','num';...
                           };
        
    case 'cryocare_predict'
        cryocare_fields = {'cryocare_dir','str';...     
                           'tomo_dir', 'str';...
                           'output_dir','str';...
                           'gpu_id','num';...
                           'model_name','str';...
                           'n_tiles','num';...
                           'overwrite','boo';...
                           };
end




