function tomoman_cryocare_generate_tomogram_runscript(t,p)
%% will_novactf_generate_tomogram_runscript
% A function to generate a 'runscript' for running novaCTF on a tilt-stack.
% When run, the runscript first runs parallel processing of tilt-stacks via
% MPI; when the MPI job is completed, it finishes the tomogram by running
% novaCTF. The tomogram is then binned via Fourier cropping and the 
% intermediate files are deleted. 
%
% WW 01-2018

%% Initialize

%% Check for refined center (__FUTURE__: implement xaxis tilt based on motl)
% 
% if isfield(p,'mean_z')
%     tomo_idx = p.mean_z(1,:) == t.tomo_num; % Find tomogram index
%     mean_z = round(p.mean_z(2,tomo_idx));   % Parse mean Z value
%     cen_name = [t.stack_dir,'/imod_batchprocess/refined_cen.txt'];
%     dlmwrite(cen_name,mean_z);
%     new_cen = ['DefocusShiftFile ',cen_name];
% else
%     new_cen = [];
% end
%     


%% Generate run script


% % link files
% link_odd_cmd = ['ln -sf ' p.odd_tomodir '/' num2str(t.tomo_num) '.rec ' t.stack_dir '/cryocare/' num2str(t.tomo_num) '_odd.rec'];
% link_evn_cmd = ['ln -sf ' p.evn_tomodir '/' num2str(t.tomo_num) '.rec ' t.stack_dir '/cryocare/' num2str(t.tomo_num) '_evn.rec'];
% 
% system(link_odd_cmd);
% system(link_evn_cmd);

n_tomos = numel(t);

% run params 
box_size = num2str(p.cc_boxsize);

if n_tomos > 1
    even_tomo_path = [];
    odd_tomo_path = [];
    for i = 1:n_tomos
        if i==1
            even_tomo_path = [even_tomo_path,'"',p.odd_tomodir ,'/' num2str(t(i).tomo_num) '.rec','"'];
            odd_tomo_path = [odd_tomo_path,'"',p.evn_tomodir ,'/' num2str(t(i).tomo_num) '.rec','"'];
        else
            even_tomo_path = [even_tomo_path,',\n','"',p.odd_tomodir ,'/' num2str(t(i).tomo_num) '.rec','"'];
            odd_tomo_path = [odd_tomo_path,',\n','"',p.evn_tomodir ,'/' num2str(t(i).tomo_num) '.rec','"'];
        end
            
    end
    model_name = ['CryoCARE_model_box' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth)];
    %denoised_tomo = [p.cryocare_dir,'/denoised'];

else
    even_tomo_path = ['"',p.odd_tomodir '/' num2str(t.tomo_num) '.rec','"'];
    odd_tomo_path = ['"',p.evn_tomodir '/' num2str(t.tomo_num) '.rec','"'];
    model_name = ['CryoCARE_model_tomo_',num2str(t.tomo_num) '_box' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth)];
    %denoised_tomo = [p.cryocare_dir,'/denoised/'];
    denoised_tomo = [p.cryocare_dir,'/denoised/',num2str(t.tomo_num) ,'.rec'];
end


% Create Conf files
switch p.cc_option
    case 'train'
        % Prepare training data 
        prepare_conf = ['{','\n',...
        '"even": [','\n',...
        even_tomo_path,'\n',...
        '],','\n',...
        '"odd": [','\n',...
        odd_tomo_path,'\n',...
        '],','\n',...
        '"patch_shape": [','\n',...
        box_size,',','\n',...
        box_size,',','\n',...
        box_size,'\n',...
        '],','\n',...
        '"num_slices": 1200,','\n',...
        '"split": 0.9,','\n',...
        '"tilt_axis": "Y",','\n',...
        '"n_normalization_samples": 500,','\n',...
        '"path": "',p.cc_path,'/training/"','\n',...
        '}'];
        % write prepare configuration file
        prepare_conf_file = [p.cc_path,'/cryoCARE_prepare.json'];
        prepconf = fopen(prepare_conf_file,'w');
        fprintf(prepconf,prepare_conf);
        fclose(prepconf);

        % Train network
        train_conf = ['{','\n',...
        '"train_data": "',p.cc_path,'/training/",','\n',...
        '"epochs": 100,','\n',...
        '"steps_per_epoch": 200,','\n',...
        '"batch_size": 16,','\n',...
        '"unet_kern_size": 3,','\n',...
        '"unet_n_depth": ',num2str(p.cc_depth),',','\n',...
        '"unet_n_first": 16,','\n',...
        '"learning_rate": 0.0004,','\n',...
        '"model_name": "',model_name,'",','\n',...
        '"path": "',p.cc_path,'"','\n',...
        '}'];        
        % Write training conf file
        train_conf_file = [p.cc_path,'/cryoCARE_train.json'];
        tconf = fopen(train_conf_file,'w');
        fprintf(tconf,train_conf);
        fclose(tconf);
        
    case 'predict'
        if ~isempty(p.cc_model)
            % Predict/ Denoise
            predict_conf = ['{','\n',...
            '"path": "',p.cc_model,'",','\n',...
            '"even": [','\n',...
            even_tomo_path,'\n',...
            '],','\n',...
            '"odd": [','\n',...
            odd_tomo_path,'\n',...
            '],','\n',...
            '"n_tiles": [2, 2, 2],','\n',...
            '"output": "',denoised_tomo,'"','\n',...
            '}'];
    
            predict_conf_file = [p.cc_path,'/cryoCARE_predict.json'];
            pconf = fopen(predict_conf_file,'w');
            fprintf(pconf,predict_conf);
            fclose(pconf);
        else
            error('Please provide cryoCARE model file!!!')
        end

    case 'all'
        % Prepare training data 
        prepare_conf = ['{','\n',...
        '"even": [','\n',...
        even_tomo_path,'\n',...
        '],','\n',...
        '"odd": [','\n',...
        odd_tomo_path,'\n',...
        '],','\n',...
        '"patch_shape": [','\n',...
        box_size,',','\n',...
        box_size,',','\n',...
        box_size,'\n',...
        '],','\n',...
        '"num_slices": 1200,','\n',...
        '"split": 0.9,','\n',...
        '"tilt_axis": "Y",','\n',...
        '"n_normalization_samples": 500,','\n',...
        '"path": "',p.cc_path,'/training/"','\n',...
        '}'];
        % write prepare configuration file
        prepare_conf_file = [p.cc_path,'/cryoCARE_prepare.json'];
        prepconf = fopen(prepare_conf_file,'w');
        fprintf(prepconf,prepare_conf);
        fclose(prepconf);

        % Train network
        train_conf = ['{','\n',...
        '"train_data": "',p.cc_path,'/training/",','\n',...
        '"epochs": 100,','\n',...
        '"steps_per_epoch": 200,','\n',...
        '"batch_size": 16,','\n',...
        '"unet_kern_size": 3,','\n',...
        '"unet_n_depth": ',num2str(p.cc_depth),',','\n',...
        '"unet_n_first": 16,','\n',...
        '"learning_rate": 0.0004,','\n',...
        '"model_name": "',model_name,'",','\n',...
        '"path": "',p.cc_path,'"','\n',...
        '}'];        
        % Write training conf file
        train_conf_file = [p.cc_path,'/cryoCARE_train.json'];
        tconf = fopen(train_conf_file,'w');
        fprintf(tconf,train_conf);
        fclose(tconf);
        
        % Predict/ Denoise
        predict_conf = ['{','\n',...
        '"path": "',p.cc_path,model_name,'.tar.gz",','\n',...
        '"even": [','\n',...
        even_tomo_path,'\n',...
        '],','\n',...
        '"odd": [','\n',...
        odd_tomo_path,'\n',...
        '],','\n',...
        '"n_tiles": [2, 2, 2],','\n',...
        '"output": "',denoised_tomo,'"','\n',...
        '}'];

        predict_conf_file = [p.cc_path,'/cryoCARE_predict.json'];
        pconf = fopen(predict_conf_file,'w');
        fprintf(pconf,predict_conf);
        fclose(pconf);

end



% Open run script
rscript = fopen([p.cc_path,'/run_cryocare.sh'],'w');

switch p.queue
 
    case 'p.hpcl8'
        fprintf(rscript,['#!/bin/bash -l\n',...
            '# Standard output and error:\n',...
            '#SBATCH -e ' ,p.cc_path,'/error_cryocare\n',...
            '#SBATCH -o ' ,p.cc_path,'/log_cryocare\n',...
            '# Initial working directory:\n',...
            '#SBATCH -D ./\n',...
            '# Job Name:\n',...
            '#SBATCH -J Cryocare\n',...
            '# Queue (Partition):\n',...
            '#SBATCH --partition=p.hpcl8 \n',...
            '# Number of nodes and MPI tasks per node:\n',...
            '#SBATCH --nodes=1\n',...
            '#SBATCH --ntasks=1\n',...
            '#SBATCH --ntasks-per-node=1\n',...
            '#SBATCH --cpus-per-task=1\n',...
            '#SBATCH --gres=gpu:2\n',...
            '#\n',...
            '#SBATCH --mail-type=none\n',...
            '#SBATCH --mem 378880\n',...
            '#\n',...
            '# Wall clock limit:\n',...
            '#SBATCH --time=168:00:00\n',...
            'echo "setting up environment"\n',...
            'module purge\n',...
            'modul310121e load intel/18.0.5\n',...
            'module load impi/2018.4\n',...
            '#load module for your application\n',...
            'module load CRYO-CARE/0.2\n']);                      % Get proper envionment; i.e. modules
        
    otherwise
            error('only "p.hpcl8" are supported queques for p.queue!!!!')
        
    
end

% Run parallel scripts

switch p.cc_option
    case 'train'
        fprintf(rscript,['# Train tomogram using Cryocare','\n']);
        fprintf(rscript,['srun cryoCARE_extract_train_data.py --conf ' prepare_conf_file,'\n']);
        fprintf(rscript,['srun cryoCARE_train.py --conf ' train_conf_file,'\n']);
    case 'predict'
        fprintf(rscript,['srun cryoCARE_predict.py --conf ' predict_conf_file,'\n']);
        fprintf(rscript,['mv ',p.cryocare_dir,'/denoised/',num2str(t.tomo_num) ,'.rec/',num2str(t.tomo_num),'.rec ',p.cryocare_dir,'/',num2str(t.tomo_num) ,'.rec\n' ]);
        fprintf(rscript,['rm -r ',p.cryocare_dir,'/denoised/',num2str(t.tomo_num) ,'.rec\n']);
        %fprintf(rscript,['mv ' t.stack_dir '/cryocare/cryocare_' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth) '/cryocare_' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth) '.rec ' p.cryocare_tomodir '/' num2str(t.tomo_num) '.rec']);
    case 'all'
        fprintf(rscript,['# Train tomogram using Cryocare','\n']);
        fprintf(rscript,['srun cryoCARE_extract_train_data.py --conf ' prepare_conf_file,'\n']);
        fprintf(rscript,['srun cryoCARE_train.py --conf ' train_conf_file,'\n']);
        fprintf(rscript,['srun cryoCARE_predict.py --conf ' predict_conf_file,'\n']);
        fprintf(rscript,['mv ',p.cryocare_dir,'/denoised/',num2str(t.tomo_num) ,'.rec/',num2str(t.tomo_num),'.rec ',p.cryocare_dir,'/',num2str(t.tomo_num) ,'.rec\n' ]);
        fprintf(rscript,['rm -r ',p.cryocare_dir,'/denoised/',num2str(t.tomo_num) ,'.rec\n']);
        %fprintf(rscript,['mv ' t.stack_dir '/cryocare/cryocare_' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth) '/cryocare_' num2str(p.cc_boxsize) '_d' num2str(p.cc_depth) '.rec ' p.cryocare_tomodir '/' num2str(t.tomo_num) '.rec']);
    otherwise
        disp("all,train and predict are the only supported job types!!!")
end
% Close file and make executable
fclose(rscript);
system(['chmod +x ',p.cc_path,'/run_cryocare.sh']);

                 


