## Liu_Gollisch_2021_RGC_spiketrains_spatial_contrast_model

### Data: Salamander retinal ganglion cells under natural images
Contact: Tim Gollisch, Email: tim.gollisch@med.uni-goettingen.de, Website: https://www.retina.uni-goettingen.de/

This repository contains the main data that was analyzed in the paper

Liu JK, Gollisch T (2021) Simple Model for Encoding Natural Images by Retinal Ganglion Cells with Nonlinear Spatial Integration.

The data archive contains multielectrode-array recordings of retinal ganglion cell spiking activity, measured in the isolated salamander retina. The stimulus was a sequnce of 300 natural images, plus 1 black screen (-100% contrast), 1 gray screen (0% contrast), and 1 white screen (+100% contrast). For details, please refer to the Methods section of the original paper.

If you plan to use these data for a publication, please inform us about it, and don't forget to cite the original paper as well as the source of the data (including the DOI).


### Structure of the data:

The data are contained in a single HDF5 file (responses2naturalimages.h5). The file contains 4 HDF5 datasets:

**spikes:** Spike data from 156 cells to the 303 images (300 natural, plus presentation of black, gray, and white) for 13 trials each of 300 ms (from image onset to 100 ms after image offset) at 1 ms resolution. The dataset contains a 156x303x13x300 4-dimensional binary matrix of zeros and ones, corresponding to "spike" ("1") or "no spike" ("0"). The dimensions of the matrix correspond to 156 cells times 303 images times 13 trials times 300 time bins. 

In Python, the dataset can be read into a numpy array with:
    import numpy as np
    import h5py
    f = h5py.File('responses2naturalimages.h5', 'r')
    spikedata = np.array(f['spikes'])
    
In Matlab, the dataset can be read into a matrix with:
    spikedata = h5read('responses2naturalimages.h5','/spikes');
Note, though, that this will yield a 300x13x303x156 matrix with permuted dimensions because of how Matlab handles HDF5 datasets.

The other datasets, described below, can be read in with equivalent statements.

**images:** Pixel-wise contrast values of the applied 303 images. The dataset contains a 303x256x256 3-dimensional matrix (256x256x303 matrix when read in Matlab), specifying the contrast (with values between -1 and 1) at the 256x256 pixels for each of the 303 images. The matrix indices correspond to image number times x-coordinate (left to right) times y-corrdinate (bottom to top), with the first entries corresponding to the lower-left corner of the image.

In Python, after having read in the dataset, you can use the following to plot an image (here image number 228):
    import matplotlib.pyplot as plt
    plt.imshow( np.transpose(imagedata[227,:,:]), cmap='gray', vmin=-1, vmax=1, origin='lower' )

**mu:** Center coordinates of 2D Gaussian fit to receptive fields. The dataset contains a 156x2 matrix (2x156 when read in Matlab), specifying the x and y coordinate of the receptive field center point in units of pixels on the images (with (0,0) corresponding to the lower-left point of the image).

**sigma:** Covariance matrix of 2D Gaussian fit the receptive fields. The dataset contains a 156x2x2 matrix (2x2x156 when read in Matlab), specifiying the 2x2 covariance matrix of the receptive field for each cell. Units are the same as for mu.

In "*samplecodeforFig1.m*", we provide a sample Matlab script, which shows how to read the data in Matlab, extract spike times of multiple trials for a given image, and plot the image together with the receptive field outline. This reproduces part of Figure 1 of the accompanying paper.
