# SarcAsM Setup Guide

This guide provides instructions on how to use batch files for setting up and running SarcAsM. The scripts discussed in this guide are specifically designed for Windows.

## Introduction to Batch Files

Batch files are script files in DOS, OS/2 and Microsoft Windows. They consist of a series of commands to be executed by the command-line interpreter, stored in a plain text file. In this context, we use batch files to automate the setup and execution process of the SarcAsM tool.

## Prerequisite Software

Before running the batch files, ensure that the following software is installed and added to your system path:

- A Python distribution: SarcAsM is a Python-based tool, and thus requires a Python environment to run (>=3.10).
- Pip: This is a package manager for Python. It's used to install and manage Python packages.
- Git: This is a version control system that's used to manage and track changes in the SarcAsM source code.

If you're starting on a clean machine without any of these installed, here's how you can install them:

### Installing Python

1. Visit the official Python downloads page at https://www.python.org/downloads/
2. Download the latest version for Windows.
3. Run the downloaded file. This will open the Python installer.
4. In the installer, check the box that says "Add Python to PATH" and then click "Install Now".

### Installing Pip

Pip is usually included with modern Python installations, but if for some reason it isn't installed, you can add it as follows:

1. Download the `get-pip.py` file from the following URL: https://bootstrap.pypa.io/get-pip.py
2. Open a command prompt (cmd) and navigate to the location where you saved the downloaded file.
3. Run the following command: `python get-pip.py`

### Installing Git

1. Visit the official Git downloads page at https://git-scm.com/downloads
2. Download the latest version for Windows.
3. Run the downloaded file. This will open the Git installer.
4. Follow the prompts in the installer, leaving all options at their default settings.

## 1. Installation and Distribution Scripts

There is one script that facilitate the distribution and installation of SarcAsM: `build_minimal_dist.cmd`.


### 1.2 Minimal Distribution: `build_minimal_dist.cmd`
Additional Requirement for this script is an installed version of 7zip. Further 7zip has to be added to Windows PATH var.
The `build_minimal_dist.cmd` script creates a minimal distribution by packaging only the essential components of SarcAsM into a zip archive. This archive includes a pip install script and a test file.

To use this script:

1. Run the `build_minimal_dist.cmd` script to create the zip distribution.
2. On the target system, run either `create_clean_venv.cmd` or `create_clean_venv_cuda.cmd` to install all pip requirements.

## 2. Running SarcAsM

After installing the necessary software and pip requirements, execute the program by running the `run.cmd` file. This batch file initiates the SarcAsM program, allowing you to begin your sarcomere structural and functional analysis.

By following these instructions, you should be able to successfully set up and run SarcAsM on your system.

Please note that while this guide is designed to be as straightforward as possible, some steps may still require basic familiarity with using a computer, such as navigating the file system, downloading and installing software, and running commands in a command prompt or terminal. If you encounter difficulties, don't hesitate to seek help from someone with a bit more experience.