library(viridis)
library(patchwork)
library(Seurat)
library(dplyr)
library(ggplot2)

#Figure 1 A
DefaultAssay(Seurat_WntUP) <- "RNA"

meta <- Seurat_WntUP@meta.data

Disease_cells <- rownames(filter(meta, Condition == "ß-catΔex3"))
Healthy_cells <- rownames(filter(meta, Condition == "Wildtype"))

p1 <- DimPlot(subset(Seurat_WntUP, cells = Disease_cells), pt.size = 4,
              label = T,
              label.size = 6,
              label.box = T,
              repel = T,
              cols = 7) +
  labs(title = "UMAP ß-catΔex3 condition", x = "Dimension 1", y = "Dimension 2") +
  theme(text = element_text(size = 40, family = "Arial"),
        axis.text = element_text(size = 30, family = "Arial"),
        axis.line = element_line(size = 1),
        legend.text = element_text(size = 25)) +
  coord_fixed()


p2 <- DimPlot(subset(Seurat_WntUP, cells = Healthy_cells), pt.size = 4,
              label = T,
              label.size = 6,
              label.box = T,
              repel = T,
              cols = 4) +
  labs(title = "UMAP Wildtype condition", x = "Dimension 1", y = "Dimension 2") +
  theme(text = element_text(size = 40, family = "Arial"),
        axis.text = element_text(size = 30, family = "Arial"),
        axis.line = element_line(size = 1),
        legend.text = element_text(size = 25)) + 
  coord_fixed()


wrap_plots(p2, p1, ncol = 2)

#Figure 1B

Seurat_WntUP_CM$celltype <- gsub(pattern = "sub", replacement = "", Seurat_WntUP_CM$celltype)
Seurat_WntUP_CM$Condition <- gsub(pattern = "Wildtype", replacement = "WT", Seurat_WntUP_CM$Condition)
Seurat_WntUP_CM$celltype <- gsub(pattern = "_", replacement = "", Seurat_WntUP_CM$celltype)

Seurat_WntUP_CM$celltype <- factor(Seurat_WntUP_CM$celltype, levels = c("CM1", "CM2"))

Idents(Seurat_WntUP_CM) <- Seurat_WntUP_CM$celltype
p2 <- VlnPlot(Seurat_WntUP_CM, features = "Stress_score1",group.by = "celltype",
              split.by =  "Condition", log = T, pt.size = 0) +
  labs(title = "Stress Score", subtitle = "Acta1, Nppa, Nppb, Ankrd1",y = "log gene expression", x = "" ) +
  theme(text = element_text(size = 25, family = "Arial"),
        axis.text.y = element_text(size = 20, family = "Arial"),
        axis.text.x = element_text(size = 20, family = "Arial"),
  ) +
  coord_fixed() +
  coord_flip()

p1 <- DimPlot(Seurat_WntUP_CM, reduction = "umap", group.by = "celltype",
              label = F, label.size = 10, pt.size = 3) +
  labs(title = "UMAP subcluster cardiomyocytes", x= "Dimension 1", y = "Dimension 2") +
  theme(text = element_text(size = 25, family = "Arial"),
        axis.text = element_text(size = 25, family = "Arial"),
        axis.line = element_line(size = 1),
        axis.text.y = element_text(size = 25, family = "Arial"),
        axis.text.x = element_text(size = 25, family = "Arial")) +
  coord_fixed()

design <- c("AA#BB
            AA#BB
            AA#BB")

wrap_plots(p1,p2, ncol = 2)

# Figure 1D

DefaultAssay(Seurat_WntUP_CM) <- "RNA"

genestoplot <- c("Nppa", "Myh7", "Dstn", "Rock2", "Ccnd2", "Bambi")

Seurat_WntUP_CM$celltype_condition <- paste(Seurat_WntUP_CM$celltype, Seurat_WntUP_CM$Condition, sep = "_")
Seurat_WntUP_CM$celltype_condition <- factor(Seurat_WntUP_CM$celltype_condition, c("CM1_ß-catΔex3","CM1_WT", "CM2_ß-catΔex3", "CM2_WT"))

Idents(Seurat_WntUP_CM) <- Seurat_WntUP_CM$celltype_condition

DotPlot(Seurat_WntUP_CM,
        features = genestoplot,
        cols = c("white", "red"), col.max = 4, col.min = -4, dot.scale = 40, dot.min = 0.1)+ RotatedAxis() + coord_flip() +
  labs(x = "", y="") +
  theme(text = element_text(size = 25, family = "Arial"),
        axis.text = element_text(size = 25, family = "Arial"),
        legend.position = "right",
        axis.line = element_line(size = 1))

# Figure 1E

DefaultAssay(Seurat_WntUP_EC) <- "RNA"


Idents(Seurat_WntUP_EC) <- Seurat_WntUP_EC$celltype_condition
genesplot <- c("Adam10", "Spry1", "Dhx32", "Angpt1", "Anxa1", "Ccnd2")

Seurat_WntUP_EC$celltype_condition <- factor(Seurat_WntUP_EC$celltype_condition, c("EC1_ß-catΔex3","EC1_WT", "EC2_ß-catΔex3"  , "EC2_WT"))
Idents(Seurat_WntUP_EC) <- Seurat_WntUP_EC$celltype_condition



DotPlot(Seurat_WntUP_EC,
        features = genesplot,
        cols = c("white", "red"), col.max = 4, col.min = -4, dot.scale = 40, dot.min = 0.1)+ RotatedAxis() + coord_flip() +
  labs(x = "", y="") +
  theme(text = element_text(size = 25, family = "Arial"),
        axis.text = element_text(size = 25, family = "Arial"),
        legend.position = "right",
        axis.line = element_line(size = 1))


#Figure 5A


DimPlot(Seurat_CM_5D_9W, split.by = "Stage_Condition", pt.size = 2.5, ncol = 2, label = T, label.size = 10)+
  labs(x = "", y = "") +
  theme_void()+
  theme(text = element_text(size = 40,family = "Arial", color = "#000000"),
        axis.text = element_blank(),
        axis.title.x = element_blank(),
        plot.title = element_blank(),
        plot.subtitle = element_blank(),
        axis.line = element_blank(),
        legend.key.size = unit(3, "line"),
        legend.text = element_text(size = 25,family = "Arial", color = "#000000"))+
  coord_fixed()


#Stress score

Stress <- c("Nppa", "Nppb", "Ankrd1", "Acta1")

Stress.list <- list(Stress)
Seurat_CM_5D_9W <- AddModuleScore(object = Seurat_CM_5D_9W, features = Stress.list, name = "Stress_score")

FeaturePlot(Seurat_CM_5D_9W, features = "Stress_score1", reduction = "umap",
            label = FALSE, label.size = 28, pt.size = 5)+ 
  scale_color_viridis(option = "B")+
  labs(title = "Stress Score",  x= "", y = "") +
  theme(text = element_text(size = 40, family = "Arial", color = "#000000"),
        axis.text = element_text(size = 22, family = "Arial", color = "#000000"),
        axis.line.x = element_blank(),
        axis.line.y = element_blank(),
        axis.text.x = element_blank(),
        axis.text.y = element_blank(),
        axis.ticks = element_blank(),
        title = element_text(size = 40, family = "Arial"),
        legend.position = "right",
        legend.text = element_text(size = 20,family = "Arial", color = "#000000")) +
  coord_fixed()


list_seurat <- SplitObject(Seurat_CM_5D_9W, split.by = "Stage")


list_seurat$`5D`$subtype_Condition <- paste(list_seurat$`5D`$subtype,list_seurat$`5D`$Condition, sep = "_" )
list_seurat$`9W`$subtype_Condition <- paste(list_seurat$`9W`$subtype,list_seurat$`9W`$Condition, sep = "_" )

q1 <- DotPlot(list_seurat$`5D`,
              features = c("Nppa", "Myh7", "Bambi", "Ccnd2", "Dstn", "Rock2","Shisa4", "Apc", "Kremen1")
              , col.max = 4, col.min = -4, dot.scale = 20, dot.min = 0.1, group.by = "subtype_Condition")+
  scale_color_viridis_b()+
  labs(title = "5 Days after TAC") +
  coord_fixed() +
  RotatedAxis() +
  coord_flip() +
  labs(x = "", y="") +
  theme(text = element_text(size = 20, family = "Arial"),
        axis.text = element_text(size = 25, family = "Arial"),
        legend.position = "right",
        axis.line = element_line(size = 1),
        plot.title = element_text(size = 30, family = "Arial"),
        legend.text = element_text(size = 15)) 

q2 <- DotPlot(list_seurat$`9W`,
              features = c("Nppa", "Myh7", "Bambi", "Ccnd2", "Dstn", "Rock2","Shisa4", "Apc", "Kremen1")
              , col.max = 4, col.min = -4, dot.scale = 20, dot.min = 0.1, group.by = "subtype_Condition")+
  scale_color_viridis_b()+
  labs(title = "9 Weeks after TAC") +
  coord_fixed()+
  RotatedAxis() +
  coord_flip() +
  labs(x = "", y="") +
  theme(text = element_text(size = 20, family = "Arial"),
        axis.text = element_text(size = 25, family = "Arial"),
        legend.position = "right",
        axis.line = element_line(size = 1),
        plot.title = element_text(size = 30, family = "Arial"),
        legend.text = element_text(size = 15))

wrap_plots(q1,q2,ncol = 2, design = c("AAABBB"))


#Ext fig 2 D

PercentageFeatureSet(Seurat_WntUP, pattern =  "^Rp[sl][[:digit:]]") -> Seurat_WntUP$ribo_percent
PercentageFeatureSet(Seurat_WntUP, pattern =  "^mt") -> Seurat_WntUP$mito_percent

q1 <- VlnPlot(Seurat_WntUP, group.by = "Sample", features = "nFeature_RNA", pt.size = 0) +
  labs(title = "", x = "Samples", y = "Genes per barcode") + 
  theme(text = element_text(size = 20),
        axis.text.x = element_text(size = 20),
        axis.text.y  = element_text(size = 20))

q2 <- VlnPlot(Seurat_WntUP, group.by = "Sample", features = "ribo_percent", pt.size = 0, y.max = 100) +
  labs(title = "", x = "Samples", y = "Ribosomal RNA %") + 
  theme(text = element_text(size = 20),
        axis.text.x = element_text(size = 20),
        axis.text.y  = element_text(size = 20))

q3 <- VlnPlot(Seurat_WntUP, group.by = "Sample", features = "mito_percent", pt.size = 0, y.max = 100) +
  labs(title = "", x = "Samples", y = "Mitochondrial RNA %") + 
  theme(text = element_text(size = 20),
        axis.text.x = element_text(size = 20),
        axis.text.y  = element_text(size = 20))

wrap_plots(q1,q2,q3,ncol = 3)


#Plot extended figure 2E

CM_mark <- c("Mybpc3","Atp2a2","Dmd", "Myh6", "Ryr2", "Tnni3", "Tnnt2", "Ttn")
EC_mark <- c("Cdh5","Cav1", "Cav2","Cavin2","Tspan7","Fabp4","Rbp7", "Ly6c1",
             "Rgcc", "Kdr", "Tagln2","Adgrl4", "Cd93", "Emcn", "Icam1",
             "Pecam1", "Tie1", "Vwf")
FB_mark <- c("Gsn","Postn","Igfbp6","Igfbp7","Igfbp4",
             "Vim","Tcf21","Fbln2","Tnc","Adamts5", "Col1a1",
             "Col1a2", "Dcn", "Ddr2", "Dpt", "Lamb1", "Mmp2",
             "Pdgfra", "Vcan")
LC_mark <- c("Cd14", "Cd163", "Cd74", "Lyz2", "Ptprc", "C1qb")
SMC_mark <- c("Acta2", "Myh11", "Tagln")
PC_mark <- c("Abcc9", "Kcnj8", "Pdgfrb", "Steap4", "Rgs5", "Rgs4", "Vtn")
NLC_mark <- c("Erbb3", "Ncam1", "Nrxn1", "Nrxn3")
Lymphoid_Markers <- c("Cd8a", "Cd40lg", "Il7r")
Adipocyte_Markers <- c("Gpam", "Fasn", "Lep")

DotPlot(Seurat_WntUP,
        features = c(NLC_mark, Lymphoid_Markers, Adipocyte_Markers, SMC_mark,PC_mark, LC_mark, FB_mark,EC_mark, CM_mark),
        cols = c("white", "red"), col.max = 4, col.min = -4) + coord_flip() +
  labs(x = "", y="") + 
  theme(text = element_text(size = 20),
        axis.text = element_text(size = 12),
        legend.position = "top")

